from bpy.types import Operator
from ...addon.naming import FluidLabNaming
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.geometry_nodes import add_node, connect_nodes
from ...libs.functions.geometry_nodes import get_node_index_or_identifier_by as identifier
from ...properties.lists.props_list_fluid_mesh import FluidMeshListItem

class FLUIDLAB_OT_gn_separate_meshes(Operator):
    bl_idname = "fluidlab.gn_separate_meshes"
    bl_label = "Separate"
    bl_description = "Separate Meshes"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):
        fluid_mesh = get_common_vars(context, get_fluid_mesh=True)

        active_mesh_item = fluid_mesh.active
        active_mesh_ob = active_mesh_item.ob

        GN_mod = active_mesh_ob.modifiers.get(FluidLabNaming.GN_MESH_MOD)
        if GN_mod:
            GN_mod.node_group.nodes['FirstRealizeInstances'].mute = not GN_mod.node_group.nodes['FirstRealizeInstances'].mute

        return {'FINISHED'}
